package cn.iocoder.foodnexus.module.operations.controller.app.customer;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.customer.ErpCustomerRespVO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpCustomerDO;
import cn.iocoder.foodnexus.module.erp.service.sale.ErpCustomerService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;
import static cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils.getLoginUserId;

/**
 * @author : yanghao
 * create at:  2025/10/14  17:08
 * @description: APP - 客户信息
 */
@Tag(name = "管理后台 - ERP 客户")
@RestController
@RequestMapping("/erp/customer")
@Validated
@AppSystemAuth(UserSystemEnum.CUSTOMER)
public class AppCustomerController {

    @Resource
    private ErpCustomerService customerService;

    @GetMapping("/get")
    @Operation(summary = "获得客户")
    public CommonResult<ErpCustomerRespVO> getCustomer() {
        ErpCustomerDO customer = customerService.getCustomerByUserId(getLoginUserId());
        return success(BeanUtils.toBean(customer, ErpCustomerRespVO.class, item -> {
            item.setWarehouseAreaIds(customerService.queryWarehouseAreaIdByCustomerId(item.getId()));
        }));
    }
}
