package cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo;

import cn.idev.excel.annotation.ExcelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = false) // 设置 chain = false，避免用户导入有问题
public class InquirePriceItemImportVO {

    @Schema(description = "商品名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "10941")
    @ExcelProperty("商品名称")
    @NotBlank(message = "商品名称")
    private String productName;

    @Schema(description = "商品类型", example = "李四")
    @ExcelProperty("商品类型")
    @NotBlank(message = "商品类型不能为空")
    private String categoryName;

    @Schema(description = "规格")
    @ExcelProperty("规格")
    private String productStandard;

    @Schema(description = "市场均价(元)", example = "22500")
    @ExcelProperty("市场均价")
    @NotBlank(message = "市场均价不能为空")
    private String marketPrice;

    @Schema(description = "商品单位")
    @ExcelProperty("商品单位")
    private String productUnit;

}