package cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo;

import cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo.InquirePriceItemSaveReqVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import org.springframework.validation.annotation.Validated;

@Schema(description = "管理后台 - 询价管理新增/修改 Request VO")
@Data
public class InquirePriceSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "16631")
    private Long id;

    @Schema(description = "询价主题", requiredMode = Schema.RequiredMode.REQUIRED, example = "李四")
    @NotEmpty(message = "询价主题不能为空")
    private String inquiryName;

    @Schema(description = "询价年月")
    private String inquiryYearMonth;

    @Schema(description = "items")
    @Size(min = 1, message = "items不能为空")
    @Valid
    private List<InquirePriceItemSaveReqVO> items;

}