package cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/2  11:32
 * @description: 询价推送
 */
@Data
public class InquirePricePushReqVO {

    @Schema(description = "id")
    @NotNull(message = "id不能为空")
    private Long id;

    @Schema(description = "推送客户集合")
    @NotNull(message = "推送客户不能为空")
    @Size(min = 1, message = "推送客户不能为空")
    private List<Long> customerIdList;

}
