package cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 询价管理分页 Request VO")
@Data
public class InquirePricePageReqVO extends PageParam {

    @Schema(description = "询价主题", example = "李四")
    private String inquiryName;

    @Schema(description = "询价年月")
    private String inquiryYearMonth;

    @Schema(description = "客户id", example = "6248")
    private Long customerId;

    @Schema(description = "客户名称", example = "李四")
    private String customerName;

    @Schema(description = "是否推送")
    private Boolean isPush;

    @Schema(description = "推送客户明细")
    private String pushCustomerInfo;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "创建人")
    private String creator;

}