package cn.iocoder.foodnexus.module.operations.controller.admin.inquirecustomerpush;

import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.common.util.collection.MapUtils;
import cn.iocoder.foodnexus.module.erp.api.service.ErpCustomerApi;
import cn.iocoder.foodnexus.module.erp.service.sale.ErpCustomerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import jakarta.validation.constraints.*;
import jakarta.validation.*;
import jakarta.servlet.http.*;
import java.util.*;
import java.io.IOException;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

import cn.iocoder.foodnexus.framework.excel.core.util.ExcelUtils;

import cn.iocoder.foodnexus.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.foodnexus.framework.apilog.core.enums.OperateTypeEnum.*;

import cn.iocoder.foodnexus.module.operations.controller.admin.inquirecustomerpush.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.inquirecustomerpush.InquireCustomerPushDO;
import cn.iocoder.foodnexus.module.operations.service.inquirecustomerpush.InquireCustomerPushService;

@Tag(name = "管理后台 - 询价推送-客户")
@RestController
@RequestMapping("/operations/inquire-customer-push")
@Validated
public class InquireCustomerPushController {

    @Resource
    private InquireCustomerPushService inquireCustomerPushService;

    @Autowired
    private ErpCustomerApi customerApi;

    /*@PostMapping("/create")
    @Operation(summary = "创建询价推送-客户")
    @PreAuthorize("@ss.hasPermission('operations:inquire-customer-push:create')")
    public CommonResult<Long> createInquireCustomerPush(@Valid @RequestBody InquireCustomerPushSaveReqVO createReqVO) {
        return success(inquireCustomerPushService.createInquireCustomerPush(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新询价推送-客户")
    @PreAuthorize("@ss.hasPermission('operations:inquire-customer-push:update')")
    public CommonResult<Boolean> updateInquireCustomerPush(@Valid @RequestBody InquireCustomerPushSaveReqVO updateReqVO) {
        inquireCustomerPushService.updateInquireCustomerPush(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除询价推送-客户")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('operations:inquire-customer-push:delete')")
    public CommonResult<Boolean> deleteInquireCustomerPush(@RequestParam("id") Long id) {
        inquireCustomerPushService.deleteInquireCustomerPush(id);
        return success(true);
    }

    @DeleteMapping("/delete-list")
    @Parameter(name = "ids", description = "编号", required = true)
    @Operation(summary = "批量删除询价推送-客户")
                @PreAuthorize("@ss.hasPermission('operations:inquire-customer-push:delete')")
    public CommonResult<Boolean> deleteInquireCustomerPushList(@RequestParam("ids") List<Long> ids) {
        inquireCustomerPushService.deleteInquireCustomerPushListByIds(ids);
        return success(true);
    }*/

    @GetMapping("/get")
    @Operation(summary = "获得询价推送-客户")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('operations:inquire-price:query')")
    public CommonResult<InquireCustomerPushRespVO> getInquireCustomerPush(@RequestParam("id") Long id) {
        InquireCustomerPushDO inquireCustomerPush = inquireCustomerPushService.getInquireCustomerPush(id);
        Map<Long, String> nameMap = customerApi.queryNameMapByIds(CommonUtil.asList(inquireCustomerPush.getCustomerId()));
        return success(BeanUtils.toBean(inquireCustomerPush, InquireCustomerPushRespVO.class, item ->
                MapUtils.findAndThen(nameMap, item.getCustomerId(), item::setCustomerName)));
    }

    @GetMapping("/page")
    @Operation(summary = "获得询价推送-客户分页")
    @PreAuthorize("@ss.hasPermission('operations:inquire-price:query')")
    public CommonResult<PageResult<InquireCustomerPushRespVO>> getInquireCustomerPushPage(@Valid InquireCustomerPushPageReqVO pageReqVO) {
        PageResult<InquireCustomerPushDO> pageResult = inquireCustomerPushService.getInquireCustomerPushPage(pageReqVO);
        Map<Long, String> nameMap = customerApi.queryNameMapByIds(pageResult.getList().stream().map(InquireCustomerPushDO::getCustomerId).toList());
        return success(BeanUtils.toBean(pageResult, InquireCustomerPushRespVO.class, item ->
                MapUtils.findAndThen(nameMap, item.getCustomerId(), item::setCustomerName)));
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出询价推送-客户 Excel")
    @ApiAccessLog(operateType = EXPORT)
    public void exportInquireCustomerPushExcel(@Valid InquireCustomerPushPageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<InquireCustomerPushDO> list = inquireCustomerPushService.getInquireCustomerPushPage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "询价推送-客户.xls", "数据", InquireCustomerPushRespVO.class,
                        BeanUtils.toBean(list, InquireCustomerPushRespVO.class));
    }

}