package cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaffcustomer.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 配送员客户绑定新增/修改 Request VO")
@Data
public class DeliveryStaffCustomerSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "14014")
    private Long id;

    @Schema(description = "配送员id", requiredMode = Schema.RequiredMode.REQUIRED, example = "2050")
    @NotNull(message = "配送员id不能为空")
    private Long deliveryStaffId;

    @Schema(description = "客户id/灶点id", requiredMode = Schema.RequiredMode.REQUIRED, example = "24925")
    @NotNull(message = "目标id不能为空")
    private Long targetId;

    @Schema(description = "true-灶点 / false-客户")
    @NotNull(message = "isDept不能可空")
    private Boolean isDept;

}