package cn.iocoder.foodnexus.module.erp.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : yanghao
 * create at:  2025/9/25  14:58
 * @description:
 */
@RequiredArgsConstructor
@Getter
public enum SaleOrderPickUpStatus implements ArrayValuable<String> {

    CANCEL("CANCEL", "取消", Boolean.FALSE, -1),

    TO_BE("TO_BE", "待拣", Boolean.FALSE, 0),

    PICK_UP("PICK_UP", "待接单", Boolean.FALSE, 1),

    ACCEPT("ACCEPT", "待配送", Boolean.FALSE, 2),

    ALREADY("ALREADY", "配送中", Boolean.FALSE, 3),

    ARRIVAL("ARRIVAL", "已到货", Boolean.FALSE, 4),

    SIGN("SIGN", "已签收", Boolean.FALSE, 5),

    /* ----- 退款 ------ */

    // 生成销售退货单
    RETURNS_PROCESS("RETURNS_PROCESS", "退款中 - 审核中", Boolean.TRUE, 6),

    // 销售退货单申请通过
    RETURNS_APPROVE("RETURNS_APPROVE", "退款中 - 已审核", Boolean.TRUE, 7),

    // 销售退货单申请驳回
    RETURNS_REJECT("RETURNS_REJECT", "退款失败 - 已驳回", Boolean.TRUE, 7),

    // 销售退货单根据供应商拆分为采购退货单

    // 配送员接受采购退货单
    RETURNS_STAFF_ACCEPT("RETURNS_STAFF_ACCEPT", "退款中 - 配送员接单", Boolean.TRUE, 8),

    // 配送员取件发货
    RETURNS_STAFF_ALREADY("RETURNS_STAFF_ALREADY", "退款中 - 配送员已取件", Boolean.TRUE, 9),

    // 确认收获
    RETURNS_FINISH("RETURNS_FINISH", "退款完成 - 退货完成", Boolean.TRUE, 10),

    ;

    public static final String[] ARRAYS = Arrays.stream(values()).map(SaleOrderPickUpStatus::getType).toArray(String[]::new);

    /**
     * 类型
     */
    private final String type;
    /**
     * 名字
     */
    private final String name;

    /**
     * 是否为退款流程
     */
    private final boolean isReturns;

    /**
     * 流程排序
     */
    private final int ascSort;

    public static SaleOrderPickUpStatus getByType(String pickUpStatus) {
        if (CommonUtil.isBlank(pickUpStatus)) {
            return null;
        }
        for (SaleOrderPickUpStatus em : values()) {
            if (em.getType().equals(pickUpStatus)) {
                return em;
            }
        }
        return null;
    }

    @Override
    public String[] array() {
        return ARRAYS;
    }

    public static List<String> getList(boolean isReturns) {
        return Arrays.stream(values()).filter(item->item.isReturns == isReturns).map(SaleOrderPickUpStatus::getType).collect(Collectors.toList());
    }
}
