package cn.iocoder.foodnexus.module.erp.dal.mysql.sale;


import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.query.MPJLambdaWrapperX;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order.DeliveryMyCountRespVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.order.ErpSaleOrderPageReqVO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpSaleOrderDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpSaleOrderItemDO;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpAuditStatus;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.yulichang.query.MPJQueryWrapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * ERP 销售订单 Mapper
 *
 * @author 芋道源码
 */
@Mapper
public interface ErpSaleOrderMapper extends BaseMapperX<ErpSaleOrderDO> {

    default PageResult<ErpSaleOrderDO> selectPage(ErpSaleOrderPageReqVO reqVO) {
        MPJLambdaWrapperX<ErpSaleOrderDO> query = new MPJLambdaWrapperX<ErpSaleOrderDO>()
                .likeIfPresent(ErpSaleOrderDO::getNo, reqVO.getNo())
                .eqIfPresent(ErpSaleOrderDO::getCustomerId, reqVO.getCustomerId())
                .betweenIfPresent(ErpSaleOrderDO::getOrderTime, reqVO.getOrderTime())
                .eqIfPresent(ErpSaleOrderDO::getStatus, reqVO.getStatus())
                .likeIfPresent(ErpSaleOrderDO::getRemark, reqVO.getRemark())
                .eqIfPresent(ErpSaleOrderDO::getCreator, reqVO.getCreator())
                // .eqIfPresent(ErpSaleOrderDO::getDeliveryStaffId, reqVO.getDeliveryStaffId())
                .betweenIfPresent(ErpSaleOrderDO::getAcceptTime, reqVO.getAcceptTime())
                .geIfPresent(ErpSaleOrderDO::getAcceptTime, reqVO.getAcceptTimeBegin())
                .leIfPresent(ErpSaleOrderDO::getAcceptTime, reqVO.getAcceptTimeEnd())
                .eqIfPresent(ErpSaleOrderDO::getPickUpStatus, reqVO.getPickUpStatus())
                .inIfPresent(ErpSaleOrderDO::getPickUpStatus, reqVO.getPickUpStatusList())
                .eqIfPresent(ErpSaleOrderDO::getCustomerDeptId, reqVO.getCustomerDeptId())
                .inIfPresent(ErpSaleOrderDO::getCustomerDeptId, reqVO.getCustomerDeptIds())
                .orderByDesc(ErpSaleOrderDO::getId);
        if (CommonUtil.isNotEmpty(reqVO.getDeliveryStaffId())) {
            query.and(orQuery -> {
               orQuery.eq(ErpSaleOrderDO::getDeliveryStaffId, reqVO.getDeliveryStaffId());
                orQuery.or().eq(ErpSaleOrderDO::getReturnsDeliveryStaffId, reqVO.getDeliveryStaffId());
            });
        }
        // 入库状态。为什么需要 t. 的原因，是因为联表查询时，需要指定表名，不然会报 out_count 错误
        if (Objects.equals(reqVO.getOutStatus(), ErpSaleOrderPageReqVO.OUT_STATUS_NONE)) {
            query.eq(ErpSaleOrderDO::getOutCount, 0);
        } else if (Objects.equals(reqVO.getOutStatus(), ErpSaleOrderPageReqVO.OUT_STATUS_PART)) {
            query.gt(ErpSaleOrderDO::getOutCount, 0).apply("t.out_count < t.total_count");
        } else if (Objects.equals(reqVO.getOutStatus(), ErpSaleOrderPageReqVO.OUT_STATUS_ALL)) {
            query.apply("t.out_count = t.total_count");
        }
        // 退货状态
        if (Objects.equals(reqVO.getReturnStatus(), ErpSaleOrderPageReqVO.RETURN_STATUS_NONE)) {
            query.eq(ErpSaleOrderDO::getReturnCount, 0);
        } else if (Objects.equals(reqVO.getReturnStatus(), ErpSaleOrderPageReqVO.RETURN_STATUS_PART)) {
            query.gt(ErpSaleOrderDO::getReturnCount, 0).apply("t.return_count < t.total_count");
        } else if (Objects.equals(reqVO.getReturnStatus(), ErpSaleOrderPageReqVO.RETURN_STATUS_ALL)) {
            query.apply("t.return_count = t.total_count");
        }
        // 可销售出库
        if (Boolean.TRUE.equals(reqVO.getOutEnable())) {
            query.eq(ErpSaleOrderDO::getStatus, ErpAuditStatus.APPROVE.getStatus())
                    .apply("t.out_count < t.total_count");
        }
        // 可销售退货
        if (Boolean.TRUE.equals(reqVO.getReturnEnable())) {
            query.eq(ErpSaleOrderDO::getStatus, ErpAuditStatus.APPROVE.getStatus())
                    .apply("t.return_count < t.out_count");
        }
        if (reqVO.getProductId() != null) {
            query.leftJoin(ErpSaleOrderItemDO.class, ErpSaleOrderItemDO::getOrderId, ErpSaleOrderDO::getId)
                    .eq(reqVO.getProductId() != null, ErpSaleOrderItemDO::getProductId, reqVO.getProductId())
                    .groupBy(ErpSaleOrderDO::getId); // 避免 1 对多查询，产生相同的 1
        }
        if (CommonUtil.isNotEmpty(reqVO.getType())) {
            if (reqVO.getType() == 1) {
                query.in(ErpSaleOrderDO::getPickUpStatus, SaleOrderPickUpStatus.getList(Boolean.FALSE));
            } else if (reqVO.getType() == 2) {
                query.in(ErpSaleOrderDO::getPickUpStatus, SaleOrderPickUpStatus.getList(Boolean.TRUE));
            }
        }
        return selectJoinPage(reqVO, ErpSaleOrderDO.class, query);
    }

    default int updateByIdAndStatus(Long id, Integer status, ErpSaleOrderDO updateObj) {
        return update(updateObj, new LambdaUpdateWrapper<ErpSaleOrderDO>()
                .eq(ErpSaleOrderDO::getId, id).eq(ErpSaleOrderDO::getStatus, status));
    }

    default ErpSaleOrderDO selectByNo(String no) {
        return selectOne(ErpSaleOrderDO::getNo, no);
    }

    default DeliveryMyCountRespVO queryMyCount(Long userId) {
        MPJQueryWrapper<ErpSaleOrderDO> wrapper = new MPJQueryWrapper<>();
        wrapper.select("COUNT(*) AS allCount");
        wrapper.select("SUM(CASE WHEN YEAR (accept_time)=YEAR (CURDATE()) AND MONTH (accept_time)=MONTH (CURDATE()) THEN 1 ELSE 0 END) AS monthCount");
        wrapper.select("SUM(CASE WHEN DATE (accept_time)=CURDATE() THEN 1 ELSE 0 END) AS todayCount");
        wrapper.eq("delivery_staff_id", userId);
        return this.selectJoinOne(DeliveryMyCountRespVO.class, wrapper);
    }

    default Long statusCount(List<String> types, Long userId) {
        return this.selectCount(Wrappers.<ErpSaleOrderDO>lambdaQuery()
                .eq(ErpSaleOrderDO::getDeliveryStaffId, userId)
                .in(ErpSaleOrderDO::getPickUpStatus, types));
    }

    default Long statusCount(List<String> types, Set<Long> deptIds) {
        return this.selectCount(Wrappers.<ErpSaleOrderDO>lambdaQuery()
                .in(ErpSaleOrderDO::getCustomerDeptId, deptIds)
                .in(ErpSaleOrderDO::getPickUpStatus, types));
    }
}