package cn.iocoder.foodnexus.module.erp.dal.dataobject.stock;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpAuditStatus;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * ERP 其它出库单 DO
 *
 * @author 芋道源码
 */
@TableName("erp_stock_out")
@KeySequence("erp_stock_out_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpStockOutDO extends BaseDO {

    /**
     * 出库编号
     */
    @TableId
    private Long id;
    /**
     * 出库单号
     */
    private String no;
    /**
     * 客户编号
     *
     * TODO 芋艿：待关联
     */
    private Long customerId;
    /**
     * 出库时间
     */
    private LocalDateTime outTime;
    /**
     * 合计数量
     */
    private BigDecimal totalCount;
    /**
     * 合计金额，单位：分
     */
    private BigDecimal totalPrice;
    /**
     * 状态
     *
     * 枚举 {@link ErpAuditStatus}
     */
    private Integer status;
    /**
     * 备注
     */
    private String remark;
    /**
     * 附件 URL
     */
    private String fileUrl;

}