package cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.supplier;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

@Schema(description = "管理后台 - ERP 供应商分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ErpSupplierPageReqVO extends PageParam {

    @Schema(description = "id集合")
    private List<Long> idList;

    @Schema(description = "id")
    private Long id;

    @Schema(description = "供应商名称", example = "芋道源码")
    private String name;

    @Schema(description = "手机号码", example = "15601691300")
    private String mobile;

    @Schema(description = "联系电话", example = "18818288888")
    private String telephone;

    @Schema(description = "联系人")
    private String contact;

    @Schema(description = "统一社会信用代码")
    private String unifiedSocialCreditCode;

    @Schema(description = "审核状态")
    private String auditStatus;

    @Schema(description = "状态")
    private Integer status;

    @Schema(description = "")
    private String businessGoodsType;

}