package cn.iocoder.foodnexus.framework.signature.config;

import cn.iocoder.foodnexus.framework.redis.config.FoodnexusRedisAutoConfiguration;
import cn.iocoder.foodnexus.framework.signature.core.aop.ApiSignatureAspect;
import cn.iocoder.foodnexus.framework.signature.core.redis.ApiSignatureRedisDAO;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

/**
 * HTTP API 签名的自动配置类
 *
 * @author Zhougang
 */
@AutoConfiguration(after = FoodnexusRedisAutoConfiguration.class)
public class FoodnexusApiSignatureAutoConfiguration {

    @Bean
    public ApiSignatureAspect signatureAspect(ApiSignatureRedisDAO signatureRedisDAO) {
        return new ApiSignatureAspect(signatureRedisDAO);
    }

    @Bean
    public ApiSignatureRedisDAO signatureRedisDAO(StringRedisTemplate stringRedisTemplate) {
        return new ApiSignatureRedisDAO(stringRedisTemplate);
    }

}
